//
//  iCloud.h
//  DsUtilities
//
//  Created by Dirk Stichling on 24.01.2013.
//  Copyright (c) 2013 Dirk Stichling. All rights reserved.
//

#import <Foundation/Foundation.h>

@class Track;
@class TrackPhoto;
@class TrackPoint;

@protocol iCloud <NSObject>

- (void) startup;

- (BOOL) enableSupport;
- (void) disableSupportKeepAllTracks;
- (void) disableSupportRemoveTracksOnComputer;
- (void) disableSupportRemoveTracksiniCloud;
- (BOOL) available;
- (BOOL) active;
- (BOOL) enabled;

- (void) forceSynchronization;

- (NSURL*) photosURL;
- (NSURL*) urlForServiceName:(NSString*)name;
- (id) usediCloudToken;
- (BOOL) deleteTrackFromiCloud:(Track*)track deletePhotos:(BOOL)deletePhotos;
- (void) writeTrackToiCloud:(Track*)track;
- (NSString*) movePhotoToiCloud:(NSString*)path forTrackPhoto:(TrackPhoto*)trackPhoto;
- (void) newTrackInTrackLibrary:(Track*)track;
- (NSURL*) urlForPhotoId:(NSString*)photoId;
- (NSURL*) urlForThumbnailPhotoId:(NSString*)photoId;
- (BOOL) isFileDownloaded:(NSURL*)url;
- (BOOL) downloadFileIfNotAvailable:(NSURL*)file;
- (BOOL) coordinatedFileRead:(NSString*)filename inBlock:(void (^)(NSURL*) )theBlock;
- (BOOL) coordinatedURLRead:(NSURL*)url inBlock:(void (^)(NSURL*) )theBlock;

- (void) syncPois;
- (void) updatePOI:(TrackPoint*)poi;
- (void) deletePOI:(TrackPoint*)poi;

@end
