//
//  MercatorTransform.h
//  DsUltilities
//
//  Created by Dirk Stichling on 29.01.08.
//  Copyright 2008 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/MyCocoa.h>


@interface MercatorTransform : NSObject {
    NSPoint _offset;
}

+ (NSPoint) convertLatitude:(double)latitude longitude:(double)longitude zoomLevel:(double)zoomLevel;
+ (NSPoint) convertX:(double)x Y:(double)y zoomLevel:(double)zoomLevel;
+ (NSPoint) convertX:(double)x Y:(double)y zoomLevel:(double)zoomLevel centerLatitude:(double)centerLatitude CenterLongitude:(double)centerLongitude;

+ (MercatorTransform*) MercatorTransformWithCenterLongitude:(double)centerLongitude centerLatitude:(double)centerLatitude zoomLevel:(double)zoomLevel;
- (id) initWithCenterLongitude:(double)centerLongitude centerLatitude:(double)centerLatitude zoomLevel:(double)zoomLevel;

- (NSPoint) centeredConvertLatitude:(double)latitude longitude:(double)longitude zoomLevel:(double)zoomLevel;

+ (double) getPixelWidthFromMeters:(double)meters zoomLevel:(double)zoomLevel;
+ (double) getMetersFromPixelWidth:(double)pixelWidth zoomLevel:(double)zoomLevel;

+ (void) degree:(float)degreeIn ToDegree:(int*)degreeOut minutes:(int*)minutes seconds:(float*)seconds;
+ (NSString*) stringForLatitude:(double)latitude longitudeRef:(double)longitude;
+ (NSString*) stringForLongitude:(double)longitude;

@end
