//
//  ISODate.h
//  DsUltilities
//
//  Created by Dirk Stichling on 17.02.08.
//  Copyright 2008 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/MyCocoa.h>

@interface ISODate : NSObject {
    NSDate* _date;
    int _timezoneOffsetInMinutes;
}

+ (ISODate*) isoDateWithString:(NSString*)description;
+ (ISODate*) isoDateWithDate:(NSDate*)date;
+ (ISODate*) isoDateWithIsoDate:(ISODate*)date;

- (NSDate*) date;

- (id) initWithString:(NSString*)description;
- (id) initWithDate:(NSDate*)date;
- (id) initWithIsoDate:(ISODate*)date;
- (id) initWithTimeIntervalSinceReferenceDate:(NSTimeInterval)secsToBeAdded;

+ (ISODate*) isoDateWithEXIFString:(NSString*)description;
- (id) initWithEXIFString:(NSString*)description;

+ (ISODate*) isoDateWithTimeIntervalSinceReferenceDate:(NSTimeInterval)timeInterval;
+ (ISODate*) isoDateWithTimeIntervalSince1970:(NSTimeInterval)timeInterval;

- (void) setTimezoneOffsetInMinutes:(int)timezoneOffsetInMinutes;

- (NSString*) descriptionWithTimezone:(BOOL)withTimezone;
- (NSString*) description;
+ (NSString*) descriptionOfTimezone:(int)timezoneOffsetInMinutes;
- (NSString*) descriptionForGui;
- (NSString*) descriptionForGuiOrdering;
- (NSString*) descriptionForExiftool;
- (NSString*) descriptionOfTimezone;
- (NSString*) standardizedDateFormat;
- (NSString*) descriptionForFileName;
- (NSString*) gpsDateStamp;
- (NSString*) gpsTimeStamp;
- (NSString*) stringFor:(NSString*)formatterString;
- (NSString*) localStringFor:(NSString*)formatterString;

- (ISODate*) convertLocalTimeToUTC:(int)timezoneOffsetInMinutes;

- (int) timezoneOffset;

- (ISODate*) copy;

+ (BOOL) convertTimezoneString:(NSString*)string offsetInMinutes:(int*)offsetInMinutes;

+ (NSString*) timeDifferenceString:(NSTimeInterval)timeInterval;

- (NSTimeInterval) timeIntervalSinceIsoDate:(ISODate*)anotherDate;
- (NSTimeInterval) timeIntervalSinceReferenceDate;
- (NSTimeInterval) timeIntervalSinceNow;

- (NSComparisonResult) compare:(ISODate*)otherDate;

- (ISODate*) dateByAddingYears:(NSInteger)timeshiftYears months:(NSInteger)timeshiftMonths days:(NSInteger)timeshiftDays hours:(NSInteger)timeshiftHours minutes:(NSInteger)timeshiftMinutes seconds:(NSInteger)timeshiftSeconds;

- (void) years:(NSInteger*)years months:(NSInteger*)months days:(NSInteger*)days hours:(NSInteger*)hours minutes:(NSInteger*)minutes seconds:(NSInteger*)seconds sinceDate:(ISODate*)referenceTime;

@end

