//
//  Sandbox.h
//  myTracks
//
//  Created by Dirk Stichling on 01.07.12.
//  Copyright (c) 2012 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>

@interface DsSandbox : NSObject {
    BOOL helpShown;
}

+ (DsSandbox*) singleton;
+ (BOOL)       isSandboxed;

- (NSString*)  base64bookmarkForURL:(NSURL*)url;
- (NSString*) base64bookmarkForFile:(NSString*)filename;
- (NSURL*) urlForBase64Bookmark:(NSString*)base64bookmark;
- (NSURL*) urlForBase64Bookmark:(NSString*)base64bookmark bookmarkIsStale:(BOOL*)bookmarkIsStale;
- (BOOL) canAccessURL:(NSURL*)url;
- (BOOL) canAccessFile:(NSString*)filename;

@end
