//
//  DsPreferences.h
//  DsUtilities
//
//  Created by Dirk Stichling on 14.03.08.
//  Copyright 2008 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/MyCocoa.h>
#import <DsUtilities/iCloud.h>
#import <DsUtilities/WorkflowHelp.h>

typedef enum
{
    GpsModeDirect,
    GpsModeUsbStorage,
    GpsModeLoadMyTracks
} GpsMode;

typedef enum
{
    RawModeXmpAll,
    RawModeOriginal,
    RawModeXmpGpsOnly
} RawMode;

typedef enum
{
    PaperlessCachingHTML,
    PaperlessCachingPlainText
} PaperlessCachingMode;

typedef enum
{
    ImportGpxAttachmentsDoNotImport,
    ImportGpxAttachmentsImport,
    ImportGpxAttachmentsImportAndDelete
} ImportGpxAttachmentsMode;

typedef enum
{
    ImportPocketQueriesDoNotImport,
    ImportPocketQueriesImport,
    ImportPocketQueriesImportAndDelete
} ImportPocketQueriesMode;

typedef enum
{
    ImportMailboxesAllInboxes,
    ImportMailboxesAllMailboxes,
    ImportMailboxesPattern
} ImportMailboxesMode;

typedef enum
{
    UnitModeMeters,
    UnitModeMiles,
    UnitModeNauticalMiles
} UnitMode;

typedef enum
{
    DiaryViewModeTrack,
    DiaryViewModeFlags,
    DiaryViewModeHide
} DiaryViewMode;

@interface DsPreferences : NSObject {
    int _geotaggingMode;
    int _dragDropMode;
    int _minIntervalSpeedCalculation;
    int _defaultTimeZone;

    GpsMode _gpsMode;
    NSString* _deviceType;
    NSString* _device;
    NSString* _additionalArguments;
    NSString* _gpsFileFormat;
    NSString* _gpsFileAdditionalArguments;

    float _defaultLatitude;
    float _defaultLongitude;
    float _defaultZoomLevel;

    int _defaultMapType;

    int _maxCacheSize;

    int _propertiesViewMode;

    BOOL _showWaypoints;
    BOOL _showPhotopoints;
    BOOL _showPhotos;
    BOOL _showCenterOfMap;
    BOOL _showDirection;
    BOOL _hideWaypoints;

    BOOL _centerMapWhenSelectingPhotos;

    BOOL _sortFoldersByName;
    BOOL _showFolderSummary;

    UnitMode _unitMode;

    DiaryViewMode _diaryViewMode;

    NSString* _googleMaps;

    BOOL _kmlExportIncludePhotos;
    int _kmlExportMaxWidth;
    int _kmlExportMaxHeight;
    int _kmlExportJPEGQuality;

    BOOL _hiddenFeatures;

    NSColor* _defaultTrackColor;
    NSColor* _firstPartOfTrackColor;
    NSColor* _secondPartOfTrackColor;
    NSColor* _selectedPartOfTrackColor;

    NSTimeInterval _firstStart;
    NSString* _firstStartHash;

    RawMode _rawFileMode;

    ImportGpxAttachmentsMode _importGpxAttachmentsMode;
    ImportPocketQueriesMode _importPocketQueriesMode;
    ImportMailboxesMode _importMailboxesMode;
    NSString* _importMailboxesPatternString;

    int _gpsDisplayFormat;

    BOOL _withBingMaps;

    id<iCloud> iCloudSynchronizer;
    id<WorkflowHelp> workflowHelp;
}

+ (DsPreferences*) singleton;

- (void) storeLatitude:(float)latitude longitude:(float)longitude zoomLevel:(int)zoomLevel;
- (void) storeShowWaypoints:(BOOL)showWaypoints showPhotopoints:(BOOL)showPhotopoints showPhotos:(BOOL)showPhotos showCenterOfMap:(BOOL)showCenterOfMap;
- (void) storeHideWaypoints:(BOOL)hideWaypoints;
- (void) storeShowDirection:(BOOL)showDirection;
- (void) storeMapType:(int)mapType;

- (void) storeKmlExportIncludePhotos:(BOOL)includePhotos;
- (void) storeKmlExportMaxWidth:(int)maxWidth;
- (void) storeKmlExportMaxHeight:(int)maxHeight;
- (void) storeKmlExportJPEGQuality:(int)jpegQuality;

- (BOOL) kmlExportIncludePhotos;
- (int) kmlExportMaxWidth;
- (int) kmlExportMaxHeight;
- (int) kmlExportJPEGQuality;

- (void) storeDragDropMode:(int)dragDropMode;
- (void) storeTimeZone:(int)timeZone;
- (void) storeGeotaggingMode:(int)geotaggingMode;
- (void) storeRawFileMode:(RawMode)mode;
- (void) storeMinIntervalSpeedCalculation:(int)minIntervalSpeedCalculation;
- (void) storeGpsMode:(int)value;
- (void) storeMaxCacheSize:(int)value;
- (void) storeCenterMapWhenSelectingPhotos:(BOOL)value;
- (void) storeDefaultTrackColor:(NSColor*)defaultTrackColor firstPartOfTrackColor:(NSColor*)firstPartOfTrackColor secondPartOfTrackColor:(NSColor*)secondPartOfTrackColor selectedPartOfTrackColor:(NSColor*)selectedPartOfTrackColor;
- (void) storeImportGpxAttachmentsMode:(int)value;
- (void) storeImportMailboxesMode:(int)value;
- (void) storeImportMailboxesPatternString:(NSString*)value;
- (void) storeSortFoldersByName:(BOOL)value;
- (void) storeShowFolderSummary:(BOOL)value;

- (BOOL) sortFoldersByName;
- (BOOL) showFolderSummary;
- (BOOL) showWaypoints;
- (BOOL) showPhotopoints;
- (BOOL) showPhotos;
- (BOOL) showCenterOfMap;
- (BOOL) showDirection;
- (BOOL) centerMapWhenSelectingPhotos;
- (BOOL) hideWaypoints;

- (int) geotaggingMode;
- (int) dragDropMode;
- (int) minIntervalSpeedCalculation;
- (int) maxCacheSize;
- (int) timeZoneInMinutes;
- (int) defaultTimeZone;

- (void) setGpsDevice:(NSString*)device type:(NSString*)type arguments:(NSString*)arguments;
- (void) setGpsStickType:(NSString*)type arguments:(NSString*)arguments;
- (void) setGpsLoadMyTracks;

- (NSString*) deviceType;
- (NSString*) device;
- (NSString*) additionalArguments;

- (float) defaultLatitude;
- (float) defaultLongitude;
- (float) defaultZoomLevel;

- (int) defaultMapTape;

- (UnitMode) unitMode;
- (void) setUnitMode:(UnitMode)value;

- (NSString*) googleMaps;

- (void) storePropertiesViewMode:(int)mode;

- (int) propertiesViewMode;

- (BOOL) hiddenFeatures;

- (NSColor*) defaultTrackColor;
- (NSColor*) firstPartOfTrackColor;
- (NSColor*) secondPartOfTrackColor;
- (NSColor*) selectedPartOfTrackColor;

- (NSString*) gpsFileFormat;
- (NSString*) gpsFileAdditionalArguments;

- (GpsMode) gpsMode;

- (void) storeFirstStart:(NSTimeInterval)firstStart hash:(NSString*)hash;
- (NSString*) firstStartHex;
- (NSTimeInterval) firstStart;

- (void) storeBool:(BOOL)value forKey:(NSString*)key;
- (void) storeInt:(int)value forKey:(NSString*)key;
- (void) storeDouble:(double)value forKey:(NSString*)key;
- (void) storeString:(NSString*)value forKey:(NSString*)key;
- (int) intForKey:(NSString*)key;
- (BOOL) boolForKey:(NSString*)key;
- (double) doubleForKey:(NSString*)key;
- (NSString*) stringForKey:(NSString*)key;

- (void) setDefaultBool:(BOOL)value forKey:(NSString*)key;
- (void) setDefaultInt:(int)value forKey:(NSString*)key;
- (void) setDefaultDouble:(double)value forKey:(NSString*)key;
- (void) setDefaultString:(NSString*)value forKey:(NSString*)key;

- (RawMode) rawFileMode;

- (ImportGpxAttachmentsMode) importGpxAttachmentsMode;
- (ImportMailboxesMode) importMailboxesMode;
- (NSString*) importMailboxesPatternString;

- (int) gpsDisplayFormat;
- (void) setGpsDisplayFormat:(int)format;

- (bool) iCloudSupported;
- (id<iCloud>) iCloudSynchronizer;
- (void) setiCloudSynchronizer:(id<iCloud>)value;

- (id<WorkflowHelp>) workflowHelp;
- (void) setWorkflowHelp:(id<WorkflowHelp>)value;

- (void) setWithBingMaps:(BOOL)value;
- (BOOL) withBingMaps;

@end
