//
//  TrackLibraryGPX.h
//  myTracks
//
//  Created by Dirk Stichling on 28.01.08.
//  Copyright 2008 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>

#import <DsTrackFramework/GpxExportConfiguration.h>
#import <DsTrackFramework/GpxImportConfiguration.h>

@class TrackLibrary;
@class TrackLibraryFolder;
@class Track;

@interface TrackLibraryGPX : NSObject <NSXMLParserDelegate>
{
    NSMutableArray* _wayPoints;
    NSMutableArray* _importedTracks;
    TrackLibraryFolder* _targetFolder;

    id _delegate;

    int _trackCounter;
    BOOL _setTimeZone;
    BOOL _removeWaypoints;
    NSString* _trackIdPrefix;

    NSString* _importFilename;
}

+ (TrackLibraryGPX*) trackLibraryGPX;
- (id) init;

// GPX Import
- (void) parser:(NSXMLParser*)parser parseErrorOccurred:(NSError*)parseError;
- (int) import:(NSString*)pathToFile configuration:(GpxImportConfiguration*)cfg;

// GPX Export
- (void) export:(NSString*) pathToFile configuration:(GpxExportConfiguration*) cfg;
- (void) exportSelected:(NSString*)pathToFile configuration:(GpxExportConfiguration*)cfg;
- (void) export:(NSString*) pathToFile selectedOnly:(BOOL) selectedOnly trackOnly:(Track*) trackOnly configuration:(GpxExportConfiguration*) cfg;
- (void) export:(NSString*) pathToFile track:(Track*) track configuration:(GpxExportConfiguration*) cfg;

- (BOOL) setTimeZone;
- (id) delegate;
- (TrackLibraryFolder*) targetFolder;

+ (void) setNextImportIsExternal;

@end

@protocol TrackLibraryGPXDelegate

- (void) notificationNewTrackWithName:(NSString*)trackName;
- (void) notificationNewTrack;
- (void) notificationNewTrackOk;
- (void) newTrackAdded:(Track*)track;

@end
