#import <DsUtilities/DsUtilities.h>

#import <DsTrackFramework/PointInTrack.h>
#import <DsTrackFramework/TrackLibraryFolder.h>
#import <DsTrackFramework/GpxExportConfiguration.h>

@class Track;
@class FileHandling;
@class ISODate;

@interface TrackLibrary : TrackLibraryFolder
{
    int _trackCounter;
    FileHandling* _fileHandling;

    Track* _waypointTrack;
    BOOL _loaded;
    
    dispatch_queue_t _syncToDiskDispatchQueue;
}

@property (readonly, atomic) Track* waypointTrack;

// convenienceAllocator
+ (TrackLibrary*) trackLibraryWithFileHandling:(FileHandling*)fileHandling;

// InitMethods
- (id) initWithFileHandling:(FileHandling*)fileHandling;
- (void) dealloc;

+ (TrackLibrary*) singleton;

// Accessors
- (void) setTrackCounter:(int)trackCounter;
- (int) trackCounter;
- (void) increaseTrackCounter;

- (FileHandling*) fileHandling;

- (void) exportGPX:(NSString*)pathToFile configuration:(GpxExportConfiguration*)cfg;
- (int) exportSelectedKML:(NSString*)pathToFile;
- (int) exportSelectedKMZ:(NSString*)kmlFilename;
- (void) exportSelectedGPX:(NSString*)pathToFile configuration:(GpxExportConfiguration*)cfg;

- (void) syncToDisk;
- (void) syncFromDisk;
- (void) cleanup;
- (BOOL) atLeastOneTrackDirty;

- (NSString*) generateFilename:(Track*)track;

- (PointInTrack) findNearestPointForLatitude:(double)latitude longitude:(double)longitude selectedTracksOnly:(BOOL)selectedTracksOnly;
- (PointInTrack) findNearestPointForLatitude:(double)latitude longitude:(double)longitude nearestPoint:(PointInTrack)nearestPoint selectedTracksOnly:(BOOL)
    selectedTracksOnly;

- (TrackLibraryFolder*) trackLibraryFolderWithPath:(NSString*)path;
- (Track*) trackWithPath:(NSString*)path;
- (TrackLibraryFolder*) folderWithPath:(NSString*)path;

- (int) importPhotosToAllTracks:(NSArray*)files foundFiles:(NSMutableDictionary*)foundFiles foundTracks:(NSMutableArray*)foundTracks callback:(void (^)(void))
    callback;
- (int) importPhotosToFirstSelectedTrack:(NSArray*)files foundDictionary:(NSMutableDictionary*)foundDictionary;
- (void) addPhotosToBeginningOrEndOfSelectedTracks:(NSArray*)files;

+ (void) joinTracks:(NSArray*)tracks;
+ (void) splitTracksAtDayLimit:(NSArray*)tracks;
+ (void) splitTracksAtWayPoints:(NSArray*)tracks;
+ (void) simplifyTracks:(NSArray*)tracks WithPointCount:(int)count processPhotoLinks:(BOOL)processPhotoLinks processWaypoints:(BOOL)processWaypoints;

@end
