//
//  Track_iCloud.h
//  myTracks21
//
//  Created by Dirk Stichling on 14.03.12.
//  Copyright (c) 2012 Dirk Stichling. All rights reserved.
//

#import <DsTrackFramework/Track.h>

@interface Track (iCloud)

+ (NSString*) trackIdFromMetadata:(NSDictionary*)metadata;
+ (NSString*) nameFromMetadata:(NSDictionary*)metadata;
+ (NSString*) iCloudIdFromMetadata:(NSDictionary*)metadata;
+ (ISODate*) startTimeFromMetadata:(NSDictionary*)metadata;
+ (ISODate*) endTimeFromMetadata:(NSDictionary*)metadata;
+ (NSInteger) photoCountFromMetadata:(NSDictionary*)metadata;
+ (NSInteger) waypointCountFromMetadata:(NSDictionary*)metadata;
+ (float) lengthFromMetadata:(NSDictionary*)metadata;
+ (NSArray*) pathFromMetadata:(NSDictionary*)metadata;
+ (NSTimeInterval) timestampFromMetadata:(NSDictionary*)metadata;

- (NSDictionary*) iCloudMetadata;
- (void) writeiCloudMetadataToURL:(NSURL*)url;
- (void) copyMetadataToTrack:(NSDictionary*)metadata;
- (void) movePhotosToiCloud;
- (void) updateLibraryFileFromiCloudFile:(NSString*)zfilename;
- (void) requestPhotosFromiCloud;

@end
