//
//  PhotosAppPhoto.h
//  DsTrackFramework
//
//  Created by Dirk Stichling on 28.01.17.
//  Copyright © 2017 Dirk Stichling. All rights reserved.
//

#import <Foundation/Foundation.h>

@class PhotosMediaItem;

@interface PhotosAppPhoto : NSObject

@property (retain, readonly) PhotosMediaItem* photosMediaItem;
@property (retain, readonly) NSNumber* latitude;
@property (retain, readonly) NSNumber* longitude;
@property (retain, readonly) NSNumber* elevation;
@property (retain, readonly) ISODate* timeOfPhoto;
@property (retain) NSString* filepath;
@property (retain, atomic) NSString* previewFilepath;

+ (PhotosAppPhoto*) photosAppPhotoWithMediaItem:(PhotosMediaItem*)photosMediaItem;

- (void) setLatitude:(double)latitude longitude:(double)longitude;

- (NSString*) id;

@end
