/*
 * LoadMyTracks.h
 */

#import <AppKit/AppKit.h>
#import <ScriptingBridge/ScriptingBridge.h>


@class LoadMyTracksApplication, LoadMyTracksGPSPlugIn;



/*
 * LoadMyTracks Suite
 */

// The application's top-level scripting object.
@interface LoadMyTracksApplication : SBApplication

- (SBElementArray*) GPSPlugIns;

@property (copy, readonly) NSString* name;  // The name of the application.
@property (readonly, atomic) BOOL frontmost;  // Is this the frontmost (active) application?
@property (copy, readonly) NSString* version;  // The version of the application.
@property (copy) LoadMyTracksGPSPlugIn* currentPlugIn;  // Current GPS Plugin

- (void)            loadGPSDataToFile:(NSURL*)toFile opening:(NSString*)opening tracks:(BOOL)tracks waypoints:(BOOL)waypoints routes:(BOOL)routes laps:(BOOL)laps pois:(BOOL)pois fromFile:(NSURL*)fromFile wait:(BOOL)wait; // Load GPS data from GPS.  Creates file on disk.  Command executes asynchronously, unless wait is used explicitly.
- (void) storeGPSDataFromFile:(NSURL*)fromFile opening:(NSString*)opening tracks:(BOOL)tracks waypoints:(BOOL)waypoints routes:(BOOL)routes laps:(BOOL)laps pois:(BOOL)pois wait:(BOOL)wait;    // Store GPS data to GPS.  Reads file from disk.  Command executes asynchronously.

@end

// Abstract representation of the plugin
@interface LoadMyTracksGPSPlugIn : SBObject

@property (copy, readonly) NSString* name;  // Programmer-determined name of the plug-in
@property (readonly, atomic) BOOL isReady;  // True if the GPS is ready to run


@end
