//
//  MapView.h
//  myTracks
//
//  Created by Dirk Stichling on 27.01.08.
//  Copyright 2008 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>
#import <DsMapFramework/MapsHandler.h>

@class MapViewPath;
@class MapViewPoint;
@class MapLayer;
@protocol MapStore;
@class MapController;
@class MapView;
@class MTImage;
@class MTAnnotationView;
@class MTArrowView;

@protocol MapViewDelegate

- (void) singleClickAtX:(float)x y:(float)y modifierFlags:(unsigned int)modifierFlags;
- (void) doubleClickAtX:(float)x y:(float)y modifierFlags:(unsigned int)modifierFlags;
- (void) scrollWheelVertical:(float)vertical horizontal:(float)horizontal x:(float)x y:(float)y flags:(NSEventModifierFlags)flags;
- (void) mapMoved:(NSSize)diff modifierFlags:(unsigned int)modifierFlags;
- (void) mapView:(MapView*)mapView keyDown:(NSEvent*)theEvent;
- (void) rectangleSelectedFrom:(NSPoint)from to:(NSPoint)to;
- (void) rectangleSelectedEndFrom:(NSPoint)from to:(NSPoint)to;
- (void) mapViewPoint:(MapViewPoint*)mapViewPoint movedTo:(NSPoint)to;

@end

@interface MapView : NSView
{
    IBOutlet NSMenu* zoomMenu;
    IBOutlet id delegate;

    NSMutableArray* _paths;
    NSMutableArray* _points;
    MapLayer* _activeMapLayer;
    id<MapStore>    _activeMapStore;
    MapLayer* _baseMapLayer;
    id<MapStore>    _baseMapLayerMapStore;
    float _zoomLevel;
    TileAndOffset _tileAndOffset;
    int _horizontalImages;
    int _verticalImages;
    NSPoint _lastPointerLocation;
    NSPoint _rectangleSelectionPointerLocation;
    BOOL _showSatelliteImages;
    BOOL _showOverlayImages;
    BOOL _showOpenStreetMap1;
    BOOL _showCenter;
    BOOL _showSmallCenter;

    NSColor* _shadowColor;
    NSColor* _borderColor;

    MTImage* _photo;
    NSImage* _photoBlob;

    BOOL _inRectangleSelection;

    MapViewPoint* _photoPoint;

    NSMutableDictionary* _dictOfAnnotation;
    NSMutableDictionary* _dictOfArrows;
    double _annotationViewScale;

    BOOL _dragging;
    BOOL _inMouseDragged;
    MapViewPoint* _draggedMapViewPoint;
    double _contentsScale;
    
    BOOL _awaken;
}

@property (assign, atomic) double contentsScale;
@property (assign) BOOL greyscale;
@property (assign) BOOL invert;

- (void) drawRect:(NSRect)rect;
- (id) initWithFrame:(NSRect)FrameRect;

- (void) dealloc;

- (void) clear;
- (void) addPath:(MapViewPath*)path;
- (void) addPoint:(MapViewPoint*)point;
- (void) removePath:(MapViewPath*)path;
- (void) removePoint:(MapViewPoint*)point;

- (NSMutableArray*) paths;
- (NSMutableArray*) points;

- (void) setActiveMapLayer:(MapLayer*)activeMapLayer;

- (float) zoomLevel;
- (void) setZoomLevel:(float)zoomLevel;
- (void) setTileAndOffset:(TileAndOffset)tileAndOffset;

- (void) mouseDown:(NSEvent*)event;
- (void) mouseUp:(NSEvent*)event;
- (void) mouseDragged:(NSEvent*)event;

- (BOOL) showCenter;
- (void) setShowCenter:(BOOL)newValue;
- (void) setShowSmallCenter:(BOOL)newValue;
- (MTImage*) photo;
- (void) setPhoto:(MTImage*)newValue;
- (MapViewPoint*) photoPoint;
- (void) setPhotoPoint:(MapViewPoint*)newValue;

- (MTAnnotationView*) annotationViewForID:(NSString*)annotationId;
- (MTArrowView*) arrowViewForID:(NSString*)arrowId;
- (void) setAnnotationViewScale:(double)scale;

- (void) updateView;

@end
