//
//  MapStore.h
//  myTracks
//
//  Created by Dirk Stichling on 30.01.08.
//  Copyright 2008 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>

@class MapLayer;
@class MapView;

@protocol MapStore

- (NSImage*) getImageForTileX:(int)tileX tileY:(int)tileY zoomLevel:(int)zoomLevel load:(BOOL)load forceLoad:(BOOL)forceLoad;
- (NSImage*) getImageForTileX:(int)tileX tileY:(int)tileY zoomLevel:(int)zoomLevel;
- (NSImage*) getImageFromMemoryForTileX:(int)tileX tileY:(int)tileY zoomLevel:(int)zoomLevel;
- (MapLayer*) mapLayer;
- (void) setMapLayer:(MapLayer*)newValue;
- (void) resetDictOfImages;
- (void) setMapView:(MapView*)mapView;

@end
