//
//  MTAnnotationView.h
//  maps4pads
//
//  Created by Dirk Stichling on 04.04.10.
//  Copyright 2010 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>

@class AnnotationStyle;

@protocol MTAnnotationViewDelegate

- (void) annotationMoved:(NSSize)diff modifierFlags:(unsigned int)modifierFlags userData:(id)userData;
- (void) annotationIdClosed:(NSString*)annotationId;

@end

@interface MTAnnotationView : NSView {
    NSTextField*     label;
    id<MTAnnotationViewDelegate> delegate;
    NSString*        annotationId;
    NSString*        text;
    NSImageView*     centerImageView;
    NSImageView*     photoImageView;

    NSPoint          lastPointerLocation;

    int              borderWidth;
    int              borderHeight;
    int              fontHeight;
    int              width;
    int              height;
    int              offsetX;
    int              offsetY;
    double           scale;

    id               userData;

    NSString*        photoFilename;
    NSImage*         photo;
    int              photoHeightFactor;

    AnnotationStyle* annotationStyle;
}

@property (readonly, atomic) NSTextField*   label;
@property (retain, nonatomic) id<MTAnnotationViewDelegate> delegate;
@property (retain, nonatomic) NSString*     annotationId;
@property (assign, atomic) double           scale;
@property (assign, atomic) id               userData;
@property (retain, atomic) AnnotationStyle* annotationStyle;

+ (NSFont*) getFontWithName:(NSString*)name size:(int)size;

- (id)      initWithAnnotationId:(NSString*)annotationIdArg;
- (void)    moveToX:(int)x y:(int)y;
- (void)    setText:(NSString*)text;
- (void)    setAnnotationHeight:(int)height;
- (void)    setPhotoFilename:(NSString*)filename;
- (void)    updateView;
- (void)    setPhotoHeightFactor:(int)heightFactor;

@end
