//
//  ExternalMapView.h
//  myTracks
//
//  Created by Dirk Stichling on 05.06.09.
//  Copyright 2009 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>

@class ExternalMapLayer;

@interface ExternalMapView : NSView {
    float                latitude;
    float                longitude;
    float                zoomLevel;

    ExternalMapLayer*    mapLayer;

    NSMutableArray*      _arrayOfMaps;

    NSMutableDictionary* _dictionaryOfLoadedImages;
    int                  _maxNumberOfImagesInCache;

    double               _contentsScale;
}

@property (readonly, atomic) float             latitude;
@property (readonly, atomic) float             longitude;
@property (readonly, atomic) float             zoomLevel;
@property (assign, atomic) double              contentsScale;

@property (readonly, atomic) ExternalMapLayer* mapLayer;

- (void) setLatitude:(float)latitude longitude:(float)longitude zoomLevel:(int)zoomLevel;

- (void) setMapLayer:(ExternalMapLayer*)mapLayerArg;

@end
