//
//  ExternlaMapMaps.h
//  myTracks
//
//  Created by Dirk Stichling on 07.06.09.
//  Copyright 2009 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>

@class ExternalMapMap;

// All ExternalMapMaps with the same zoom level

@interface ExternalMapMaps : NSObject {
    NSMutableArray* _listOfMaps;

    float           _zoomLevel;
    ExternalMapMap* _currentMap;
}

@property (readonly, atomic) float           zoomLevel;
@property (readonly, atomic) ExternalMapMap* currentMap;

+ (ExternalMapMaps*) externalMapMapsForZoomLevel:(float)zoomLevel;

- (void)             addMap:(ExternalMapMap*)map;

- (ExternalMapMap*)  mapForLatitude:(float)latitude longitude:(float)longitude;
- (void)             maps:(NSMutableArray*)array forLatitude:(float)latitude longitude:(float)longitude;

- (void)             createXMLForParent:(NSXMLElement*)parent;

- (ExternalMapMap*)  oneAndOnlyMap;

@end
