//
//  ExternalMapMap.h
//  myTracks
//
//  Created by Dirk Stichling on 05.06.09.
//  Copyright 2009 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>

@interface ExternalMapMap : NSObject {
    float     west;
    float     east;

    float     south;
    float     north;

    int       imageWidth;
    int       imageHeight;

    int       tileWidth;
    int       tileHeight;

    float     zoomLevel;
    float     scale;

    NSString* imagePathFormat;
    BOOL      hasSet;
}

+ (ExternalMapMap*) mapMap;

@property (assign, atomic) float     west;
@property (assign, atomic) float     east;

@property (assign, atomic) float     south;
@property (assign, atomic) float     north;

@property (assign, atomic) int       imageWidth;
@property (assign, atomic) int       imageHeight;

@property (assign, atomic) int       tileWidth;
@property (assign, atomic) int       tileHeight;

@property (readonly, atomic) float   zoomLevel;
@property (readonly, atomic) float   scale;

@property (retain, atomic) NSString* imagePathFormat;
@property (assign, atomic) BOOL      hasSet;

- (void)            update;

- (BOOL)            loadMapFile:(NSString*)mapFilename setFile:(NSString*)setFilename;

- (void)            createXMLForParent:(NSXMLElement*)parent;

- (float)           scaleToZoomLevel:(float)scaleZoomLevel;
- (float)           scaledZoomLevel;

@end
