//
//  ExternalMapLayer.h
//  myTracks
//
//  Created by Dirk Stichling on 05.06.09.
//  Copyright 2009 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>
#import <DsMapFramework/MapLayer.h>

@class ExternalMapMap;
@class ExternalMapMaps;

@interface ExternalMapLayer : MapLayer {
    NSMutableArray*  _listOfMapMaps;
    ExternalMapMaps* _currentMapMaps;

    NSString*        _path;
}

@property (retain, atomic) NSString* path;

+ (ExternalMapLayer*) mapLayerWithName:(NSString*)name;

- (void)              addMap:(ExternalMapMap*)map;
- (ExternalMapMaps*)  currentMaps;

- (float)             zoom:(int)level;
- (float)             setZoomLevel:(float)zoomLevel;

- (BOOL)              loadAtlasAtPath:(NSString*)path;
- (void)              rescan;

- (void)              createXMLForParent:(NSXMLElement*)parent;

@end
