//
//  MapStore.h
//  myTracks
//
//  Created by Dirk Stichling on 30.01.08.
//  Copyright 2008 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>
#import <DsMapFramework/MapStore.h>

@class MapStoreLoadThread;
@class MapView;
@class FileHandling;
@class MutexObject;
@class MapLayer;

@interface DownloadingMapStore : NSObject <MapStore> {
    NSMutableDictionary* _dictOfImages;

    NSMutableDictionary* _dictOfPendingImages;
    NSMutableDictionary* _dictOfErrorImages;
    NSMutableArray* _imageLoadQueue;

    NSCondition* _newImageToLoad;

    NSCondition* _doPurge;

    MapView* _mapView;
    MapLayer* _mapLayer;
    id _mapController;

    BOOL _atLeastOneImageDownloaded;
    BOOL _noMoreImageDownload;
    int _errorImageDownloadCounter;

    int _loadingInProgressCounter;
    NSTimer* _updateTimer;

    BOOL _threadsStarted;
}

@property (assign, nonatomic) id mapController;

+ (DownloadingMapStore*) mapStore;
- (id) init;
- (void) dealloc;

+ (int) imageCountOfAllLoadThreads;

- (NSString*) calcKeyWithTileX:(int)tileX tileY:(int)tileY zoomLevel:(int)zoomLevel;
- (NSImage*) getImageForTileX:(int)tileX tileY:(int)tileY zoomLevel:(int)zoomLevel load:(BOOL)load forceLoad:(BOOL)forceLoad;
- (NSImage*) getImageForTileX:(int)tileX tileY:(int)tileY zoomLevel:(int)zoomLevel;
- (NSImage*) getImageFromMemoryForTileX:(int)tileX tileY:(int)tileY zoomLevel:(int)zoomLevel;
- (NSImage*) loadGetImageForTileX:(int)tileX tileY:(int)tileY zoomLevel:(int)zoomLevel;
- (void) downloadImageForTileX:(int)tileX tileY:(int)tileY zoomLevel:(int)zoomLevel key:(NSString*)key;
- (NSImage*) loadImageWithKey:(NSString*)key;
- (void) saveImage:(NSImage*)image key:(NSString*)key;
- (void) couldNotLoadImageForKey:(NSString*)key;
- (NSString*) getCacheFolder;
- (void) startLoadThreads;
- (void) startPurgeThread;
- (void) setMapView:(MapView*)mapView;
- (void) updateViewWithTimer:(NSTimer*)theTimer;
- (void) updateView;
- (NSCondition*) newImageToLoad;
- (NSMutableArray*) imageLoadQueue;

- (void) increaseErrorImageDownloadCounter;
- (BOOL) noMoreImageDownload;
- (int) numberOfPendingImages;
- (BOOL) isOfflineMap;
- (void) deleteMapCache;

- (void) resetDictOfImages;

- (void) decreaseLoadingInProgressCounter;

- (MapLayer*) mapLayer;
- (void) setMapLayer:(MapLayer*)newValue;

+ (void) deleteAllCaches;
+ (void) resetRamCaches;

@end
