//
//  BookmarksFolder.h
//  myTracks
//
//  Created by Dirk Stichling on 17.04.08.
//  Copyright 2008 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>

@class MTBookmark;

@interface BookmarksFolder : NSObject {
    NSMutableArray*  _bookmarks;
    NSMutableArray*  _bookmarksFolders;

    NSString*        _name;
    BookmarksFolder* _parent;
}

+ (BookmarksFolder*) bookmarksFolder;
- (id)               init;
- (void)             dealloc;

- (NSArray*)         allBookmarks;

- (void)             addBookmark:(MTBookmark*)bookmark;
- (void)             addBookmark:(MTBookmark*)bookmark atIndex:(NSInteger)index;
- (void)             addBookmark:(MTBookmark*)bookmark previousGloudGuid:(NSString*)previousCloudGuid nextCloudGuid:(NSString*)nextCloudGuid;
- (void)             removeBookmark:(MTBookmark*)bookmark;
- (NSMutableArray*)  bookmarks;

- (void)             addBookmarksFolder:(BookmarksFolder*)bookmarksFolder;
- (void)             removeBookmarksFolder:(BookmarksFolder*)bookmarksFolder;
- (NSMutableArray*)  bookmarksFolders;

- (NSString*)        name;
- (void)             setName:(NSString*)newValue;

- (NSInteger)        indexOfBookmark:(MTBookmark*)bookmark;
- (NSInteger)        indexOfBookmarksFolder:(BookmarksFolder*)bookmarksFolder;

- (BookmarksFolder*) parent;
- (void)             setParent:(BookmarksFolder*)newValue;
- (void)             addPath:(NSMutableString*)path;
- (MTBookmark*)      bookmarkWithPath:(NSString*)path;
- (BookmarksFolder*) bookmarksFolderWithPath:(NSString*)path;

- (void)             moveBookmarkHere:(MTBookmark*)bookmark atIndex:(NSInteger)index;
- (void)             moveBookmarksFolderHere:(BookmarksFolder*)bookmarksFolder atIndex:(NSInteger)index;
- (void)             moveBookmarkHere:(MTBookmark*)bookmark previousGloudGuid:(NSString*)previousCloudGuid nextCloudGuid:(NSString*)nextCloudGuid;

- (NSString*)        path;
- (NSArray*)         allCloudGuids;
- (MTBookmark*)      bookmarkWithCloudGuid:(NSString*)cloudGuid;

@end
