//
//  ActionListController.h
//  myTracks
//
//  Created by Dirk Stichling on 27.06.08.
//  Copyright 2008 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>

@interface ActionListController : NSObject {
    IBOutlet NSTableView* actionListView;
    IBOutlet NSTextField* actionListLabel;
    IBOutlet NSPanel* actionListPanel;
    IBOutlet NSButton* cancelButton;
    IBOutlet NSProgressIndicator* progressIndicator;

    NSMutableArray* _actionTextList;
    NSMutableArray* _actionStatusList;

    int maxActions;
    int actionCounter;

    SEL _onEndSelector;
    id _onEndTarget;
    NSTimer* _updateTimer;

    BOOL _modalSessionRunning;
    BOOL _cancelButtonPressed;
}

+ (ActionListController*) singleton;

+ (void) clearList;
- (void) clearList;

- (void) incrementActionCounter;
- (void) setActionCounter:(int)newValue;

+ (void) nonModalPanelEnd;
- (void) nonModalPanelEnd;
+ (void) nonModalPanelWithTitle:(NSString*)title label:(NSString*)label;
- (void) nonModalPanelWithTitle:(NSString*)title label:(NSString*)label;
- (void) nonModalPanelWithTitle:(NSString*)title label:(NSString*)label maxActions:(int)maxActionsArg;
- (void) nonModalPanelWithTitle:(NSString*)title label:(NSString*)label onEndSelector:(SEL)onEndSelector onEndTarget:(id)onEndTarget;
- (void) nonModalPanelWithTitle:(NSString*)title label:(NSString*)label maxActions:(int)maxActionsArg onEndSelector:(SEL)onEndSelector onEndTarget:(id)onEndTarget;

- (void) setLabel:(NSString*)label;
- (void) setMaxActions:(int)arg;

+ (void) waitUntilRunning;
- (void) waitUntilRunning;
- (BOOL) cancelButtonPressed;
- (IBAction) cancelButton:(id)sender;
- (void) enableCancelButton;

- (void) runThread:(void (^)(void) )block title:(NSString*)title label:(NSString*)label;

@end
