//
//  TrackKML.h
//  myTracks
//
//  Created by Dirk Stichling on 04.01.09.
//  Copyright 2009 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>

@class Track;

@interface TrackKMLConfiguration : NSObject {
    BOOL includePhotos;
    int maxWidth;
    int maxHeight;
    float jpegQuality;
}

@property (assign, atomic) BOOL includePhotos;
@property (assign, atomic) int maxWidth;
@property (assign, atomic) int maxHeight;
@property (assign, atomic) float jpegQuality;

@end

@interface TrackKML : NSObject {
    Track* _track;
    TrackKMLConfiguration* _configuration;
}

+ (TrackKML*) trackKMLWithTrack:(Track*)track;
+ (TrackKML*) trackKMLWithTrack:(Track*)track configuration:(TrackKMLConfiguration*)configuration;
- (id) initWithTrack:(Track*)track configuration:(TrackKMLConfiguration*)configuration;

- (Track*)                 track;
- (TrackKMLConfiguration*) configuration;

// KML Export
- (void) export:(NSString*)pathToFile createKMZ:(BOOL)createKMZ;

@end
