//
//  TrackGPXElement.h
//  myTracks
//
//  Created by Dirk Stichling on 10.02.08.
//  Copyright 2008 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>

@class Track;

@interface TrackGPXElement : NSObject <NSXMLParserDelegate>
{
    Track*                          _track;

    NSXMLParser*            _parser;
    id _parserParent;

    BOOL _parserInName;
    BOOL _parserInDescription;
    BOOL _parserInTags;

    int _timezoneOffset;
    BOOL _hasTimezoneOffset;
}

+ (TrackGPXElement*) trackGPXElementForTrack:(Track*)track parser:(NSXMLParser*)parser parent:(id)parserParent;
- (id) initForTrack:(Track*)track parser:(NSXMLParser*)parser parent:(id)parserParent;

- (id)               parent;

@end
