//
//  igotu.h
//  DsTrackFramework
//
//  Created by Dirk Stichling on 09.02.2013.
//  Copyright (c) 2013 Dirk Stichling. All rights reserved.
//

#import <Foundation/Foundation.h>
#include <IOKit/IOKitLib.h>
#include <IOKit/IOCFPlugIn.h>
#include <IOKit/usb/IOUSBLib.h>
#include <IOKit/usb/USBSpec.h>

#import "GpsDriver.h"

typedef enum
{
    GTUNKNOWN,
    GT120,
    GT200,
    GT800
} LoggerType;

@class Track;

@interface IGotU : NSObject <GpsDriver> {
    @private
    unsigned char*               buffer;
    NSUInteger                   bufferEnd;
    NSUInteger                   bufferCursor;
    BOOL                         receiveThreadRunning;

    BOOL                         isGT800;

    IOUSBDeviceInterface300**    usbDevice;
    IOUSBInterfaceInterface300** usbInterface;

    LoggerType                   loggerType;
    NSUInteger                   trackPointCount;

    Track*                       currentTrack;
}

@end
