//
//  GpxExportConfiguration.h
//  myTracks21
//
//  Created by Dirk Stichling on 09.11.09.
//  Copyright 2009 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>

@interface GpxExportConfiguration : NSObject {
    BOOL exportMytracksExtensions;
    BOOL exportWaypointsOnly;
    BOOL exportiPhonePhotosOnly;
    BOOL doNotExportPhotos;
    NSString* exportTrackPointsInExternalFile;
    BOOL useGPX10;
    NSPredicate* filterPredicate;
    int indexOfTrackPointInExternalFile;
    NSString* filename;
    BOOL doNotExportBookmarks;
    BOOL doNotExportiCloudInfo;
}

@property (assign, atomic) BOOL exportMytracksExtensions;
@property (assign, atomic) BOOL exportWaypointsOnly;
@property (retain, atomic) NSString* exportTrackPointsInExternalFile;
@property (assign, atomic) int indexOfTrackPointInExternalFile;
@property (assign, atomic) BOOL exportiPhonePhotosOnly;
@property (assign, atomic) BOOL doNotExportPhotos;
@property (assign, atomic) BOOL doNotExportiCloudInfo;
@property (assign, atomic) BOOL doNotExportBookmarks;
@property (assign, atomic) BOOL useGPX10;
@property (assign, atomic) NSPredicate* filterPredicate;
@property (retain, atomic) NSString* filename;

+ (GpxExportConfiguration*) gpxExportConfiguration;

@end
