//
//  GISService.h
//  myTracks
//
//  Created by Dirk Stichling on 31.12.08.
//  Copyright 2008 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>

@protocol GISServiceConvertLocation
- (BOOL) ConvertLon:(double)lon Lat:(double)lat ToCity:(NSMutableString*)city State:(NSMutableString*)state Country:(NSMutableString*)country ISOCountryCode:(NSMutableString*)isoCountryCode Place:(NSMutableString*)place;
@end

@protocol GISServiceConvertAddress
- (BOOL) ConvertAddress:(NSString*)address toLon:(double*)lon toLat:(double*)lat;
@end


@interface GISService : NSObject {
}

- (NSString*) name;

+ (NSString*) resultStringForData:(NSData*)data;
+ (NSString*) contentOfTag:(NSString*)tag inString:(NSString*)string;
+ (NSString*) contentOfString:(NSString*)tag inString:(NSString*)string;
+ (NSString*) remainingStringAfterTag:(NSString*)tag inString:(NSString*)string;


@end
