//
//  MapViewPin.h
//  maps4pads
//
//  Created by Dirk Stichling on 05.04.10.
//  Copyright 2010 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>

@class MapViewPoint;
@class AnnotationStyle;

@interface MapViewPin : NSObject {
    BOOL             showPin;
    BOOL             showAnnotation;
    double           pinLatitude;
    double           pinLongitude;
    NSString*        text;

    BOOL             accuracyOk;
    int              accuracyInMeters;

    int              annotationHeight;

    MapViewPoint*    mapViewPoint;

    NSInteger        annotationOffsetX;
    NSInteger        annotationOffsetY;

    NSString*        photoFilename;
    NSURL*           securityScopeURL;

    int              photoHeight;
    BOOL             isHidden;

    AnnotationStyle* annotationStyle;
};

@property (assign, atomic) BOOL                showPin;
@property (assign, atomic) BOOL                showAnnotation;
@property (assign, atomic) double              pinLatitude;
@property (assign, atomic) double              pinLongitude;
@property (retain, nonatomic) NSString*        text;
@property (assign, atomic) BOOL                accuracyOk;
@property (assign, atomic) int                 accuracyInMeters;
@property (assign, atomic) int                 annotationHeight;
@property (retain, atomic) MapViewPoint*       mapViewPoint;
@property (assign, atomic) NSInteger           annotationOffsetX;
@property (assign, atomic) NSInteger           annotationOffsetY;
@property (retain, nonatomic) NSString*        photoFilename;
@property (assign, atomic) int                 photoHeight;
@property (assign, atomic) BOOL                isHidden;
@property (retain, nonatomic) AnnotationStyle* annotationStyle;
@end
