//
//  MapLayers.h
//  myTracks
//
//  Created by Dirk Stichling on 05.11.08.
//  Copyright 2008 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>

@class MapLayer;

@interface MapLayers : NSObject {
    NSMutableArray* _layers;
}

+ (MapLayers*) singleton;

- (NSMutableArray*) layers;
- (void) addMapLayer:(MapLayer*)mapLayer;
- (void) removeMapLayer:(MapLayer*)mapLayer;
- (void) deleteMapLayer:(MapLayer*)mapLayer;

- (void) syncToDisk;
- (void) syncFromDisk;

- (void) move:(MapLayer*)mapLayer before:(MapLayer*)otherLayer;
- (void) move:(MapLayer*)mapLayer after:(MapLayer*)otherLayer;

- (void) clearAllCaches;

@end
