//
//  Bookmark.h
//  myTracks
//
//  Created by Dirk Stichling on 23.02.08.
//  Copyright 2008 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>

@class BookmarksFolder;

@interface MTBookmark : NSObject {
    NSString*        _name;
    NSString*        _cloudGuid;
    double           _longitude;
    double           _latitude;
    int              _zoomLevel;

    BookmarksFolder* _parent;
}

+ (MTBookmark*)      bookmarkWithName:(NSString*)name Latitude:(double)latitude Longitude:(double)longitude zoomLevel:(int)zoomLevel;
+ (MTBookmark*)      bookmarkFromCloudData:(NSData*)data;

- (id)               initWithName:(NSString*)name Latitude:(double)latitude Longitude:(double)longitude zoomLevel:(int)zoomLevel;
- (id)               initFromCloudData:(NSData*)data;

- (void)             dealloc;

- (double)           latitude;
- (double)           longitude;
- (int)              zoomLevel;
- (NSString*)        name;
- (NSString*)        cloudGuid;

- (void)             setName:(NSString*)name;
- (void)             setZoomLevel:(int)zoomLevel;
- (void)             setLongitude:(double)longitude;
- (void)             setLatitude:(double)latitude;
- (void)             setCloudGuid:(NSString*)guid;
- (NSString*)        path;
- (NSArray*)         folderHierarchy;

- (BookmarksFolder*) parent;
- (void)             setParent:(BookmarksFolder*)newValue;

- (NSData*)          cloudData;
- (void)             updateFromCloudData:(NSData*)data;

@end
