//
//  BookmarksController.h
//  myTracks
//
//  Created by Dirk Stichling on 15.04.08.
//  Copyright 2008 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>
#import <DsMapFramework/DsMapFramework.h>

@interface BookmarksController : NSObject <NSOutlineViewDelegate, CloudElementSyncDelegate> {
    IBOutlet NSOutlineView* outlineView;
    IBOutlet NSTableColumn* nameColumn;
    IBOutlet NSTableColumn* latitudeColumn;
    IBOutlet NSTableColumn* longitudeColumn;
    IBOutlet NSTableColumn* zoomLevelColumn;

    CloudElementSync* cloudSync;

    BOOL _awaken;
}

- (void) update;
- (void) addBookmarkToCloud:(MTBookmark*)bookmark;

- (IBAction) newFolder:(id)sender;
- (IBAction) delete:(id)sender;

@end
